using System;
using System.Data.SqlTypes;
using System.Runtime.InteropServices;
using System.Security;
using System.Text;
using Microsoft.SqlServer.Server;

public static class MelissaDataDQT {
	[SuppressUnmanagedCodeSecurity]
	private class mdAddrUnmanaged {
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrCreate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrCreate();
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrDestroy", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrDestroy(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrInitialize", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrInitialize(IntPtr i, string p1, string p2, string p3);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrInitializeDataFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrInitializeDataFiles(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetInitializeErrorString", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetInitializeErrorString(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetLicenseString", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrSetLicenseString(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetBuildNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetBuildNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDatabaseDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDatabaseDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetExpirationDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetExpirationDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetLicenseExpirationDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetLicenseExpirationDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCanadianDatabaseDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCanadianDatabaseDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCanadianExpirationDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCanadianExpirationDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToUSFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToUSFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToCanadaFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToCanadaFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToDPVDataFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToDPVDataFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToLACSLinkDataFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToLACSLinkDataFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToSuiteLinkDataFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToSuiteLinkDataFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToSuiteFinderDataFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToSuiteFinderDataFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToRBDIFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToRBDIFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetRBDIDatabaseDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetRBDIDatabaseDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPathToAddrKeyDataFiles", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPathToAddrKeyDataFiles(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrClearProperties", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrClearProperties(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrResetDPV", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrResetDPV(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetCASSEnable", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetCASSEnable(IntPtr i, Int32 p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetUseUSPSPreferredCityNames", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetUseUSPSPreferredCityNames(IntPtr i, Int32 p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetDiacritics", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetDiacritics(IntPtr i, Int32 p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetStatusCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetStatusCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetErrorCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetErrorCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetErrorString", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetErrorString(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetResults", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetResults(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetResultCodeDescription", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetResultCodeDescription(IntPtr i, string resultCode, Int32 opt);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_B1_ProcessorName", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_B1_ProcessorName(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_B4_ListName", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_B4_ListName(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_D3_Name", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_D3_Name(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_D3_Company", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_D3_Company(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_D3_Address", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_D3_Address(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_D3_City", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_D3_City(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_D3_State", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_D3_State(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPS3553_D3_ZIP", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPS3553_D3_ZIP(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetFormPS3553", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetFormPS3553(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSaveFormPS3553", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrSaveFormPS3553(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrResetFormPS3553", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrResetFormPS3553(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrResetFormPS3553Counter", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrResetFormPS3553Counter(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetStandardizationType", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetStandardizationType(IntPtr i, Int32 mode);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetSuiteParseMode", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetSuiteParseMode(IntPtr i, Int32 mode);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetAliasMode", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetAliasMode(IntPtr i, Int32 mode);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetFormSOA", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetFormSOA(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSaveFormSOA", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSaveFormSOA(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrResetFormSOA", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrResetFormSOA(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetSOACustomerInfo", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetSOACustomerInfo(IntPtr i, string customerName, string customerAddress);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetSOACPCNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetSOACPCNumber(IntPtr i, string CPCNumber);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOACustomerInfo", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSOACustomerInfo(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOACPCNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSOACPCNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOATotalRecords", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetSOATotalRecords(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOAAAPercentage", CallingConvention = CallingConvention.Cdecl)]
		public static extern float mdAddrGetSOAAAPercentage(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOAAAExpiryDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSOAAAExpiryDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOASoftwareInfo", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSOASoftwareInfo(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSOAErrorString", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSOAErrorString(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetCompany", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetCompany(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetLastName", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetLastName(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetAddress", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetAddress(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetAddress2", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetAddress2(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetLastLine", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetLastLine(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetSuite", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetSuite(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetCity", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetCity(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetState", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetState(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetZip", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetZip(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetPlus4", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetPlus4(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetUrbanization", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetUrbanization(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedAddressRange", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedAddressRange(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedPreDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedPreDirection(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedStreetName", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedStreetName(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedSuffix", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedSuffix(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedPostDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedPostDirection(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedSuiteName", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedSuiteName(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedSuiteRange", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedSuiteRange(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedRouteService", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedRouteService(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedLockBox", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedLockBox(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetParsedDeliveryInstallation", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetParsedDeliveryInstallation(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetCountryCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetCountryCode(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrVerifyAddress", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrVerifyAddress(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCompany", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCompany(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetLastName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetLastName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetAddress", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetAddress(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetAddress2", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetAddress2(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSuite", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSuite(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCity", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCity(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCityAbbreviation", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCityAbbreviation(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetState", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetState(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetZip", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetZip(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPlus4", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetPlus4(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCarrierRoute", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCarrierRoute(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDeliveryPointCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDeliveryPointCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDeliveryPointCheckDigit", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDeliveryPointCheckDigit(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCountyFips", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCountyFips(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCountyName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCountyName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetAddressTypeCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetAddressTypeCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetAddressTypeString", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetAddressTypeString(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetUrbanization", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetUrbanization(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCongressionalDistrict", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCongressionalDistrict(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetLACS", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetLACS(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetLACSLinkIndicator", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetLACSLinkIndicator(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPrivateMailbox", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetPrivateMailbox(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetTimeZoneCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetTimeZoneCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetTimeZone", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetTimeZone(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetMsa", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetMsa(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPmsa", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetPmsa(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDefaultFlagIndicator", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDefaultFlagIndicator(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSuiteStatus", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSuiteStatus(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetEWSFlag", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetEWSFlag(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCMRA", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCMRA(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDsfNoStats", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDsfNoStats(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDsfVacant", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDsfVacant(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDsfDNA", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDsfDNA(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetCountryCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetCountryCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetZipType", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetZipType(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetFalseTable", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetFalseTable(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetDPVFootnotes", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetDPVFootnotes(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetLACSLinkReturnCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetLACSLinkReturnCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetSuiteLinkReturnCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetSuiteLinkReturnCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetRBDI", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetRBDI(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetELotNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetELotNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetELotOrder", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetELotOrder(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetAddressKey", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetAddressKey(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetMelissaAddressKey", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetMelissaAddressKey(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetMelissaAddressKeyBase", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetMelissaAddressKeyBase(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrFindSuggestion", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrFindSuggestion(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrFindSuggestionNext", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrFindSuggestionNext(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_B6_TotalRecords", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_B6_TotalRecords(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_C1a_ZIP4Coded", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_C1a_ZIP4Coded(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_C1c_DPBCAssigned", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_C1c_DPBCAssigned(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_C1d_FiveDigitCoded", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_C1d_FiveDigitCoded(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_C1e_CRRTCoded", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_C1e_CRRTCoded(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_C1f_eLOTAssigned", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_C1f_eLOTAssigned(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_HighRiseDefault", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_HighRiseDefault(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_HighRiseExact", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_HighRiseExact(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_RuralRouteDefault", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_RuralRouteDefault(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_RuralRouteExact", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_RuralRouteExact(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetZip4HRDefault", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetZip4HRDefault(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetZip4HRExact", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetZip4HRExact(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetZip4RRDefault", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetZip4RRDefault(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetZip4RRExact", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetZip4RRExact(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_LACSCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_LACSCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_EWSCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_EWSCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_E_DPVCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_E_DPVCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_POBoxCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_POBoxCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_HCExactCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_HCExactCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_FirmCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_FirmCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_GenDeliveryCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_GenDeliveryCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_MilitaryZipCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_MilitaryZipCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_NonDeliveryCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_NonDeliveryCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_StreetCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_StreetCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_HCDefaultCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_HCDefaultCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_OtherCount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_OtherCount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_LacsLinkCodeACount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_LacsLinkCodeACount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_LacsLinkCode00Count", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_LacsLinkCode00Count(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_LacsLinkCode14Count", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_LacsLinkCode14Count(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_LacsLinkCode92Count", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_LacsLinkCode92Count(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_LacsLinkCode09Count", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_LacsLinkCode09Count(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_SuiteLinkCodeACount", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_SuiteLinkCodeACount(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetPS3553_X_SuiteLinkCode00Count", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdAddrGetPS3553_X_SuiteLinkCode00Count(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedAddressRange", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedAddressRange(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedPreDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedPreDirection(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedStreetName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedStreetName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedSuffix", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedSuffix(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedPostDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedPostDirection(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedSuiteName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedSuiteName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedSuiteRange", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedSuiteRange(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedPrivateMailboxName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedPrivateMailboxName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedPrivateMailboxNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedPrivateMailboxNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedGarbage", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedGarbage(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedRouteService", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedRouteService(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedLockBox", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedLockBox(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetParsedDeliveryInstallation", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetParsedDeliveryInstallation(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrSetReserved", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdAddrSetReserved(IntPtr i, string p1, string p2);
		[DllImport("mdAddr.dll", EntryPoint = "mdAddrGetReserved", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdAddrGetReserved(IntPtr i, string p1);
	}

	[SqlFunction]
	public static SqlInt64 mdAddrCreate() {
		return mdAddrUnmanaged.mdAddrCreate().ToInt64();
	}

	[SqlFunction]
	public static SqlInt32 mdAddrDestroy(SqlInt64 i) {
		mdAddrUnmanaged.mdAddrDestroy((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrInitialize(SqlInt64 i, SqlString p1, SqlString p2, SqlString p3) {
		return mdAddrUnmanaged.mdAddrInitialize((IntPtr)(Int64)i, (string)p1, (string)p2, (string)p3);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrInitializeDataFiles(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrInitializeDataFiles((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlString mdAddrGetInitializeErrorString(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetInitializeErrorString((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdAddrSetLicenseString(SqlInt64 i, SqlString p1) {
		return (mdAddrUnmanaged.mdAddrSetLicenseString((IntPtr)(Int64)i, (string)p1) != 0);
	}

	[SqlFunction]
	public static SqlString mdAddrGetBuildNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetBuildNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDatabaseDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDatabaseDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetExpirationDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetExpirationDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetLicenseExpirationDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetLicenseExpirationDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCanadianDatabaseDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCanadianDatabaseDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCanadianExpirationDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCanadianExpirationDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToUSFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToUSFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToCanadaFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToCanadaFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToDPVDataFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToDPVDataFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToLACSLinkDataFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToLACSLinkDataFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToSuiteLinkDataFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToSuiteLinkDataFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToSuiteFinderDataFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToSuiteFinderDataFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToRBDIFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToRBDIFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdAddrGetRBDIDatabaseDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetRBDIDatabaseDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPathToAddrKeyDataFiles(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPathToAddrKeyDataFiles((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrClearProperties(SqlInt64 i) {
		mdAddrUnmanaged.mdAddrClearProperties((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrResetDPV(SqlInt64 i) {
		mdAddrUnmanaged.mdAddrResetDPV((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetCASSEnable(SqlInt64 i, SqlInt32 p1) {
		mdAddrUnmanaged.mdAddrSetCASSEnable((IntPtr)(Int64)i, (Int32)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetUseUSPSPreferredCityNames(SqlInt64 i, SqlInt32 p1) {
		mdAddrUnmanaged.mdAddrSetUseUSPSPreferredCityNames((IntPtr)(Int64)i, (Int32)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetDiacritics(SqlInt64 i, SqlInt32 p1) {
		mdAddrUnmanaged.mdAddrSetDiacritics((IntPtr)(Int64)i, (Int32)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdAddrGetStatusCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetStatusCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetErrorCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetErrorCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetErrorString(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetErrorString((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetResults(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetResults((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetResultCodeDescription(SqlInt64 i, SqlString resultCode, SqlInt32 opt) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetResultCodeDescription((IntPtr)(Int64)i, (string)resultCode, (Int32)opt));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_B1_ProcessorName(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_B1_ProcessorName((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_B4_ListName(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_B4_ListName((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_D3_Name(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_D3_Name((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_D3_Company(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_D3_Company((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_D3_Address(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_D3_Address((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_D3_City(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_D3_City((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_D3_State(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_D3_State((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPS3553_D3_ZIP(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPS3553_D3_ZIP((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdAddrGetFormPS3553(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetFormPS3553((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdAddrSaveFormPS3553(SqlInt64 i, SqlString p1) {
		return (mdAddrUnmanaged.mdAddrSaveFormPS3553((IntPtr)(Int64)i, (string)p1) != 0);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrResetFormPS3553(SqlInt64 i) {
		mdAddrUnmanaged.mdAddrResetFormPS3553((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrResetFormPS3553Counter(SqlInt64 i) {
		mdAddrUnmanaged.mdAddrResetFormPS3553Counter((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetStandardizationType(SqlInt64 i, SqlInt32 mode) {
		mdAddrUnmanaged.mdAddrSetStandardizationType((IntPtr)(Int64)i, (Int32)mode);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetSuiteParseMode(SqlInt64 i, SqlInt32 mode) {
		mdAddrUnmanaged.mdAddrSetSuiteParseMode((IntPtr)(Int64)i, (Int32)mode);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetAliasMode(SqlInt64 i, SqlInt32 mode) {
		mdAddrUnmanaged.mdAddrSetAliasMode((IntPtr)(Int64)i, (Int32)mode);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdAddrGetFormSOA(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetFormSOA((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSaveFormSOA(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSaveFormSOA((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrResetFormSOA(SqlInt64 i) {
		mdAddrUnmanaged.mdAddrResetFormSOA((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetSOACustomerInfo(SqlInt64 i, SqlString customerName, SqlString customerAddress) {
		mdAddrUnmanaged.mdAddrSetSOACustomerInfo((IntPtr)(Int64)i, (string)customerName, (string)customerAddress);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetSOACPCNumber(SqlInt64 i, SqlString CPCNumber) {
		mdAddrUnmanaged.mdAddrSetSOACPCNumber((IntPtr)(Int64)i, (string)CPCNumber);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdAddrGetSOACustomerInfo(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSOACustomerInfo((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetSOACPCNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSOACPCNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetSOATotalRecords(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetSOATotalRecords((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlDouble mdAddrGetSOAAAPercentage(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetSOAAAPercentage((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlString mdAddrGetSOAAAExpiryDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSOAAAExpiryDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetSOASoftwareInfo(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSOASoftwareInfo((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetSOAErrorString(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSOAErrorString((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetCompany(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetCompany((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetLastName(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetLastName((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetAddress(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetAddress((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetAddress2(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetAddress2((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetLastLine(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetLastLine((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetSuite(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetSuite((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetCity(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetCity((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetState(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetState((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetZip(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetZip((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetPlus4(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetPlus4((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetUrbanization(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetUrbanization((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedAddressRange(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedAddressRange((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedPreDirection(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedPreDirection((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedStreetName(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedStreetName((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedSuffix(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedSuffix((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedPostDirection(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedPostDirection((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedSuiteName(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedSuiteName((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedSuiteRange(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedSuiteRange((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedRouteService(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedRouteService((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedLockBox(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedLockBox((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetParsedDeliveryInstallation(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetParsedDeliveryInstallation((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetCountryCode(SqlInt64 i, SqlString p1) {
		mdAddrUnmanaged.mdAddrSetCountryCode((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlBoolean mdAddrVerifyAddress(SqlInt64 i) {
		return (mdAddrUnmanaged.mdAddrVerifyAddress((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlString mdAddrGetCompany(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCompany((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetLastName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetLastName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetAddress(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetAddress((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetAddress2(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetAddress2((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetSuite(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSuite((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCity(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCity((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCityAbbreviation(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCityAbbreviation((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetState(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetState((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetZip(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetZip((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetPlus4(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetPlus4((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCarrierRoute(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCarrierRoute((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDeliveryPointCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDeliveryPointCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDeliveryPointCheckDigit(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDeliveryPointCheckDigit((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCountyFips(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCountyFips((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCountyName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCountyName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetAddressTypeCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetAddressTypeCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetAddressTypeString(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetAddressTypeString((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetUrbanization(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetUrbanization((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCongressionalDistrict(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCongressionalDistrict((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetLACS(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetLACS((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetLACSLinkIndicator(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetLACSLinkIndicator((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetPrivateMailbox(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetPrivateMailbox((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetTimeZoneCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetTimeZoneCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetTimeZone(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetTimeZone((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetMsa(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetMsa((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetPmsa(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetPmsa((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDefaultFlagIndicator(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDefaultFlagIndicator((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetSuiteStatus(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSuiteStatus((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetEWSFlag(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetEWSFlag((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCMRA(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCMRA((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDsfNoStats(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDsfNoStats((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDsfVacant(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDsfVacant((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDsfDNA(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDsfDNA((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetCountryCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetCountryCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetZipType(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetZipType((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetFalseTable(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetFalseTable((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetDPVFootnotes(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetDPVFootnotes((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetLACSLinkReturnCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetLACSLinkReturnCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetSuiteLinkReturnCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetSuiteLinkReturnCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetRBDI(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetRBDI((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetELotNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetELotNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetELotOrder(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetELotOrder((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetAddressKey(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetAddressKey((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetMelissaAddressKey(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetMelissaAddressKey((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetMelissaAddressKeyBase(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetMelissaAddressKeyBase((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdAddrFindSuggestion(SqlInt64 i) {
		return (mdAddrUnmanaged.mdAddrFindSuggestion((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdAddrFindSuggestionNext(SqlInt64 i) {
		return (mdAddrUnmanaged.mdAddrFindSuggestionNext((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_B6_TotalRecords(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_B6_TotalRecords((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_C1a_ZIP4Coded(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_C1a_ZIP4Coded((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_C1c_DPBCAssigned(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_C1c_DPBCAssigned((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_C1d_FiveDigitCoded(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_C1d_FiveDigitCoded((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_C1e_CRRTCoded(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_C1e_CRRTCoded((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_C1f_eLOTAssigned(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_C1f_eLOTAssigned((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_HighRiseDefault(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_HighRiseDefault((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_HighRiseExact(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_HighRiseExact((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_RuralRouteDefault(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_RuralRouteDefault((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_RuralRouteExact(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_RuralRouteExact((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetZip4HRDefault(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetZip4HRDefault((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetZip4HRExact(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetZip4HRExact((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetZip4RRDefault(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetZip4RRDefault((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetZip4RRExact(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetZip4RRExact((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_LACSCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_LACSCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_EWSCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_EWSCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_E_DPVCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_E_DPVCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_POBoxCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_POBoxCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_HCExactCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_HCExactCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_FirmCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_FirmCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_GenDeliveryCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_GenDeliveryCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_MilitaryZipCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_MilitaryZipCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_NonDeliveryCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_NonDeliveryCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_StreetCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_StreetCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_HCDefaultCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_HCDefaultCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_OtherCount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_OtherCount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_LacsLinkCodeACount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_LacsLinkCodeACount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_LacsLinkCode00Count(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_LacsLinkCode00Count((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_LacsLinkCode14Count(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_LacsLinkCode14Count((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_LacsLinkCode92Count(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_LacsLinkCode92Count((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_LacsLinkCode09Count(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_LacsLinkCode09Count((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_SuiteLinkCodeACount(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_SuiteLinkCodeACount((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlInt32 mdAddrGetPS3553_X_SuiteLinkCode00Count(SqlInt64 i) {
		return mdAddrUnmanaged.mdAddrGetPS3553_X_SuiteLinkCode00Count((IntPtr)(Int64)i);
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedAddressRange(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedAddressRange((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedPreDirection(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedPreDirection((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedStreetName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedStreetName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedSuffix(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedSuffix((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedPostDirection(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedPostDirection((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedSuiteName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedSuiteName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedSuiteRange(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedSuiteRange((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedPrivateMailboxName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedPrivateMailboxName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedPrivateMailboxNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedPrivateMailboxNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedGarbage(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedGarbage((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedRouteService(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedRouteService((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedLockBox(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedLockBox((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdAddrGetParsedDeliveryInstallation(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetParsedDeliveryInstallation((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdAddrSetReserved(SqlInt64 i, SqlString p1, SqlString p2) {
		mdAddrUnmanaged.mdAddrSetReserved((IntPtr)(Int64)i, (string)p1, (string)p2);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdAddrGetReserved(SqlInt64 i, SqlString p1) {
		return Marshal.PtrToStringAnsi(mdAddrUnmanaged.mdAddrGetReserved((IntPtr)(Int64)i, (string)p1));
	}

	[SuppressUnmanagedCodeSecurity]
	private class mdParseUnmanaged {
		[DllImport("mdAddr.dll", EntryPoint = "mdParseCreate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseCreate();
		[DllImport("mdAddr.dll", EntryPoint = "mdParseDestroy", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdParseDestroy(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseInitialize", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdParseInitialize(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetBuildNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetBuildNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseParse", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdParseParse(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseParseCanadian", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdParseParseCanadian(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseParseNext", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdParseParseNext(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseLastLineParse", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdParseLastLineParse(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetZip", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetZip(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetPlus4", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetPlus4(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetCity", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetCity(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetState", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetState(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetStreetName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetStreetName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetRange", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetRange(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetPreDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetPreDirection(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetPostDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetPostDirection(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetSuffix", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetSuffix(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetSuiteName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetSuiteName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetSuiteNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetSuiteNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetPrivateMailboxNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetPrivateMailboxNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetPrivateMailboxName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetPrivateMailboxName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetGarbage", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetGarbage(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetRouteService", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetRouteService(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetLockBox", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetLockBox(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseGetDeliveryInstallation", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdParseGetDeliveryInstallation(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdParseParseRule", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdParseParseRule(IntPtr i);
	}

	[SqlFunction]
	public static SqlInt64 mdParseCreate() {
		return mdParseUnmanaged.mdParseCreate().ToInt64();
	}

	[SqlFunction]
	public static SqlInt32 mdParseDestroy(SqlInt64 i) {
		mdParseUnmanaged.mdParseDestroy((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdParseInitialize(SqlInt64 i, SqlString p1) {
		return mdParseUnmanaged.mdParseInitialize((IntPtr)(Int64)i, (string)p1);
	}

	[SqlFunction]
	public static SqlString mdParseGetBuildNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetBuildNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdParseParse(SqlInt64 i, SqlString p1) {
		mdParseUnmanaged.mdParseParse((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdParseParseCanadian(SqlInt64 i, SqlString p1) {
		mdParseUnmanaged.mdParseParseCanadian((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlBoolean mdParseParseNext(SqlInt64 i) {
		return (mdParseUnmanaged.mdParseParseNext((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlInt32 mdParseLastLineParse(SqlInt64 i, SqlString p1) {
		mdParseUnmanaged.mdParseLastLineParse((IntPtr)(Int64)i, (string)p1);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdParseGetZip(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetZip((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetPlus4(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetPlus4((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetCity(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetCity((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetState(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetState((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetStreetName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetStreetName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetRange(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetRange((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetPreDirection(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetPreDirection((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetPostDirection(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetPostDirection((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetSuffix(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetSuffix((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetSuiteName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetSuiteName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetSuiteNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetSuiteNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetPrivateMailboxNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetPrivateMailboxNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetPrivateMailboxName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetPrivateMailboxName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetGarbage(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetGarbage((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetRouteService(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetRouteService((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetLockBox(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetLockBox((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdParseGetDeliveryInstallation(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdParseUnmanaged.mdParseGetDeliveryInstallation((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlInt32 mdParseParseRule(SqlInt64 i) {
		return mdParseUnmanaged.mdParseParseRule((IntPtr)(Int64)i);
	}

	[SuppressUnmanagedCodeSecurity]
	private class mdStreetUnmanaged {
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetCreate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetCreate();
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetDestroy", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdStreetDestroy(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetInitialize", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdStreetInitialize(IntPtr i, string p1, string p2, string p3);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetInitializeErrorString", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetInitializeErrorString(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetDatabaseDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetDatabaseDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetBuildNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetBuildNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetSetLicenseString", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdStreetSetLicenseString(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetLicenseExpirationDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetLicenseExpirationDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetFindStreet", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdStreetFindStreet(IntPtr i, string p1, string p2, Int32 p3);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetFindStreetNext", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdStreetFindStreetNext(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetIsAddressInRange", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdStreetIsAddressInRange(IntPtr i, string p1, string p2, string p3);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetIsAddressInRange2", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdStreetIsAddressInRange2(IntPtr i, string p1, string p2, string p3, string p4);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetAutoCompletion", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetAutoCompletion(IntPtr i, string p1, string p2, Int32 p3, Int32 p4);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetResetAutoCompletion", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdStreetResetAutoCompletion(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetBaseAlternateIndicator", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetBaseAlternateIndicator(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetLACSIndicator", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetLACSIndicator(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetUrbanizationCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetUrbanizationCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetUrbanizationName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetUrbanizationName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetLastLineNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetLastLineNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetAddressType", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetAddressType(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetCongressionalDistrict", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetCongressionalDistrict(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetCountyFips", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetCountyFips(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetCompany", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetCompany(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetCarrierRoute", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetCarrierRoute(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetZip", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetZip(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetDeliveryInstallation", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetDeliveryInstallation(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPlus4High", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPlus4High(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPlus4Low", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPlus4Low(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetSuiteRangeOddEven", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetSuiteRangeOddEven(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetSuiteRangeHigh", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetSuiteRangeHigh(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetSuiteRangeLow", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetSuiteRangeLow(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetSuiteName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetSuiteName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPostDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPostDirection(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetSuffix", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetSuffix(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetStreetName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetStreetName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPreDirection", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPreDirection(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPrimaryRangeOddEven", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPrimaryRangeOddEven(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPrimaryRangeHigh", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPrimaryRangeHigh(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdStreetGetPrimaryRangeLow", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdStreetGetPrimaryRangeLow(IntPtr i);
	}

	[SqlFunction]
	public static SqlInt64 mdStreetCreate() {
		return mdStreetUnmanaged.mdStreetCreate().ToInt64();
	}

	[SqlFunction]
	public static SqlInt32 mdStreetDestroy(SqlInt64 i) {
		mdStreetUnmanaged.mdStreetDestroy((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdStreetInitialize(SqlInt64 i, SqlString p1, SqlString p2, SqlString p3) {
		return mdStreetUnmanaged.mdStreetInitialize((IntPtr)(Int64)i, (string)p1, (string)p2, (string)p3);
	}

	[SqlFunction]
	public static SqlString mdStreetGetInitializeErrorString(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetInitializeErrorString((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetDatabaseDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetDatabaseDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetBuildNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetBuildNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdStreetSetLicenseString(SqlInt64 i, SqlString p1) {
		return (mdStreetUnmanaged.mdStreetSetLicenseString((IntPtr)(Int64)i, (string)p1) != 0);
	}

	[SqlFunction]
	public static SqlString mdStreetGetLicenseExpirationDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetLicenseExpirationDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdStreetFindStreet(SqlInt64 i, SqlString p1, SqlString p2, SqlBoolean p3) {
		return (mdStreetUnmanaged.mdStreetFindStreet((IntPtr)(Int64)i, (string)p1, (string)p2, (p3 ? 1 : 0)) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdStreetFindStreetNext(SqlInt64 i) {
		return (mdStreetUnmanaged.mdStreetFindStreetNext((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdStreetIsAddressInRange(SqlInt64 i, SqlString p1, SqlString p2, SqlString p3) {
		return (mdStreetUnmanaged.mdStreetIsAddressInRange((IntPtr)(Int64)i, (string)p1, (string)p2, (string)p3) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdStreetIsAddressInRange2(SqlInt64 i, SqlString p1, SqlString p2, SqlString p3, SqlString p4) {
		return (mdStreetUnmanaged.mdStreetIsAddressInRange2((IntPtr)(Int64)i, (string)p1, (string)p2, (string)p3, (string)p4) != 0);
	}

	[SqlFunction]
	public static SqlString mdStreetGetAutoCompletion(SqlInt64 i, SqlString p1, SqlString p2, SqlInt32 p3, SqlBoolean p4) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetAutoCompletion((IntPtr)(Int64)i, (string)p1, (string)p2, (Int32)p3, (p4 ? 1 : 0)));
	}

	[SqlFunction]
	public static SqlInt32 mdStreetResetAutoCompletion(SqlInt64 i) {
		mdStreetUnmanaged.mdStreetResetAutoCompletion((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlString mdStreetGetBaseAlternateIndicator(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetBaseAlternateIndicator((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetLACSIndicator(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetLACSIndicator((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetUrbanizationCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetUrbanizationCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetUrbanizationName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetUrbanizationName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetLastLineNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetLastLineNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetAddressType(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetAddressType((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetCongressionalDistrict(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetCongressionalDistrict((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetCountyFips(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetCountyFips((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetCompany(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetCompany((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetCarrierRoute(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetCarrierRoute((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetZip(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetZip((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetDeliveryInstallation(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetDeliveryInstallation((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPlus4High(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPlus4High((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPlus4Low(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPlus4Low((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetSuiteRangeOddEven(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetSuiteRangeOddEven((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetSuiteRangeHigh(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetSuiteRangeHigh((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetSuiteRangeLow(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetSuiteRangeLow((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetSuiteName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetSuiteName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPostDirection(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPostDirection((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetSuffix(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetSuffix((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetStreetName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetStreetName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPreDirection(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPreDirection((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPrimaryRangeOddEven(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPrimaryRangeOddEven((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPrimaryRangeHigh(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPrimaryRangeHigh((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdStreetGetPrimaryRangeLow(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdStreetUnmanaged.mdStreetGetPrimaryRangeLow((IntPtr)(Int64)i));
	}

	[SuppressUnmanagedCodeSecurity]
	private class mdZipUnmanaged {
		[DllImport("mdAddr.dll", EntryPoint = "mdZipCreate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipCreate();
		[DllImport("mdAddr.dll", EntryPoint = "mdZipDestroy", CallingConvention = CallingConvention.Cdecl)]
		public static extern void mdZipDestroy(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipInitialize", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipInitialize(IntPtr i, string p1, string p2, string p3);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetInitializeErrorString", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetInitializeErrorString(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetDatabaseDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetDatabaseDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetBuildNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetBuildNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipSetLicenseString", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipSetLicenseString(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetLicenseExpirationDate", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetLicenseExpirationDate(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipFindZip", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipFindZip(IntPtr i, string p1, Int32 p2);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipFindZipNext", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipFindZipNext(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipFindZipInCity", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipFindZipInCity(IntPtr i, string p1, string p2);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipFindZipInCityNext", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipFindZipInCityNext(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipFindCityInState", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipFindCityInState(IntPtr i, string p1, string p2);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipFindCityInStateNext", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipFindCityInStateNext(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipComputeDistance", CallingConvention = CallingConvention.Cdecl)]
		public static extern double mdZipComputeDistance(IntPtr i, double p1, double p2, double p3, double p4);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipComputeBearing", CallingConvention = CallingConvention.Cdecl)]
		public static extern double mdZipComputeBearing(IntPtr i, double p1, double p2, double p3, double p4);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetCountyNameFromFips", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetCountyNameFromFips(IntPtr i, string p1);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetSCFArea", CallingConvention = CallingConvention.Cdecl)]
		public static extern Int32 mdZipGetSCFArea(IntPtr i, string p1, IntPtr p2, IntPtr p3, IntPtr p4, IntPtr p5);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetZip", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetZip(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetCity", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetCity(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetCityAbbreviation", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetCityAbbreviation(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetState", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetState(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetZipType", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetZipType(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetCountyName", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetCountyName(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetCountyFips", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetCountyFips(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetAreaCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetAreaCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetLongitude", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetLongitude(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetLatitude", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetLatitude(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetTimeZone", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetTimeZone(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetTimeZoneCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetTimeZoneCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetMsa", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetMsa(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetPmsa", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetPmsa(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetFacilityCode", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetFacilityCode(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetLastLineIndicator", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetLastLineIndicator(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetLastLineNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetLastLineNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetPreferredLastLineNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetPreferredLastLineNumber(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetAutomation", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetAutomation(IntPtr i);
		[DllImport("mdAddr.dll", EntryPoint = "mdZipGetFinanceNumber", CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr mdZipGetFinanceNumber(IntPtr i);
	}

	[SqlFunction]
	public static SqlInt64 mdZipCreate() {
		return mdZipUnmanaged.mdZipCreate().ToInt64();
	}

	[SqlFunction]
	public static SqlInt32 mdZipDestroy(SqlInt64 i) {
		mdZipUnmanaged.mdZipDestroy((IntPtr)(Int64)i);
		return 0;
	}

	[SqlFunction]
	public static SqlInt32 mdZipInitialize(SqlInt64 i, SqlString p1, SqlString p2, SqlString p3) {
		return mdZipUnmanaged.mdZipInitialize((IntPtr)(Int64)i, (string)p1, (string)p2, (string)p3);
	}

	[SqlFunction]
	public static SqlString mdZipGetInitializeErrorString(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetInitializeErrorString((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetDatabaseDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetDatabaseDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetBuildNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetBuildNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdZipSetLicenseString(SqlInt64 i, SqlString p1) {
		return (mdZipUnmanaged.mdZipSetLicenseString((IntPtr)(Int64)i, (string)p1) != 0);
	}

	[SqlFunction]
	public static SqlString mdZipGetLicenseExpirationDate(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetLicenseExpirationDate((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlBoolean mdZipFindZip(SqlInt64 i, SqlString p1, SqlBoolean p2) {
		return (mdZipUnmanaged.mdZipFindZip((IntPtr)(Int64)i, (string)p1, (p2 ? 1 : 0)) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdZipFindZipNext(SqlInt64 i) {
		return (mdZipUnmanaged.mdZipFindZipNext((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdZipFindZipInCity(SqlInt64 i, SqlString p1, SqlString p2) {
		return (mdZipUnmanaged.mdZipFindZipInCity((IntPtr)(Int64)i, (string)p1, (string)p2) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdZipFindZipInCityNext(SqlInt64 i) {
		return (mdZipUnmanaged.mdZipFindZipInCityNext((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdZipFindCityInState(SqlInt64 i, SqlString p1, SqlString p2) {
		return (mdZipUnmanaged.mdZipFindCityInState((IntPtr)(Int64)i, (string)p1, (string)p2) != 0);
	}

	[SqlFunction]
	public static SqlBoolean mdZipFindCityInStateNext(SqlInt64 i) {
		return (mdZipUnmanaged.mdZipFindCityInStateNext((IntPtr)(Int64)i) != 0);
	}

	[SqlFunction]
	public static SqlDouble mdZipComputeDistance(SqlInt64 i, SqlDouble p1, SqlDouble p2, SqlDouble p3, SqlDouble p4) {
		return mdZipUnmanaged.mdZipComputeDistance((IntPtr)(Int64)i, (double)p1, (double)p2, (double)p3, (double)p4);
	}

	[SqlFunction]
	public static SqlDouble mdZipComputeBearing(SqlInt64 i, SqlDouble p1, SqlDouble p2, SqlDouble p3, SqlDouble p4) {
		return mdZipUnmanaged.mdZipComputeBearing((IntPtr)(Int64)i, (double)p1, (double)p2, (double)p3, (double)p4);
	}

	[SqlFunction]
	public static SqlString mdZipGetCountyNameFromFips(SqlInt64 i, SqlString p1) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetCountyNameFromFips((IntPtr)(Int64)i, (string)p1));
	}

	[SqlFunction]
	public static SqlInt32 mdZipGetSCFArea(SqlInt64 i, SqlString p1, SqlInt64 p2, SqlInt64 p3, SqlInt64 p4, SqlInt64 p5) {
		return mdZipUnmanaged.mdZipGetSCFArea((IntPtr)(Int64)i, (string)p1, (IntPtr)(Int64)p2, (IntPtr)(Int64)p3, (IntPtr)(Int64)p4, (IntPtr)(Int64)p5);
	}

	[SqlFunction]
	public static SqlString mdZipGetZip(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetZip((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetCity(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetCity((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetCityAbbreviation(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetCityAbbreviation((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetState(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetState((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetZipType(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetZipType((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetCountyName(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetCountyName((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetCountyFips(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetCountyFips((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetAreaCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetAreaCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetLongitude(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetLongitude((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetLatitude(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetLatitude((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetTimeZone(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetTimeZone((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetTimeZoneCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetTimeZoneCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetMsa(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetMsa((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetPmsa(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetPmsa((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetFacilityCode(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetFacilityCode((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetLastLineIndicator(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetLastLineIndicator((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetLastLineNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetLastLineNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetPreferredLastLineNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetPreferredLastLineNumber((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetAutomation(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetAutomation((IntPtr)(Int64)i));
	}

	[SqlFunction]
	public static SqlString mdZipGetFinanceNumber(SqlInt64 i) {
		return Marshal.PtrToStringAnsi(mdZipUnmanaged.mdZipGetFinanceNumber((IntPtr)(Int64)i));
	}

	private class Utf8String : IDisposable {
		private IntPtr utf8String = IntPtr.Zero;

		public Utf8String(string str) {
			if (str == null)
				str = "";
			byte[] buffer = Encoding.UTF8.GetBytes(str);
			Array.Resize(ref buffer, buffer.Length + 1);
			buffer[buffer.Length - 1] = 0;
			utf8String = Marshal.AllocHGlobal(buffer.Length);
			Marshal.Copy(buffer, 0, utf8String, buffer.Length);
		}

		~Utf8String() {
			Dispose();
		}

		public virtual void Dispose() {
			lock (this) {
				Marshal.FreeHGlobal(utf8String);
				GC.SuppressFinalize(this);
			}
		}

		public IntPtr GetUtf8Ptr() {
			return utf8String;
		}

		public static string GetUnicodeString(IntPtr ptr) {
			if (ptr == IntPtr.Zero)
				return "";
			int len = 0;
			while (Marshal.ReadByte(ptr, len) != 0)
				len++;
			if (len == 0)
				return "";
			byte[] buffer = new byte[len];
			Marshal.Copy(ptr, buffer, 0, len);
			return Encoding.UTF8.GetString(buffer);
		}
	}
}
